/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.WailaClientRegistration;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.create.CreatePlugin;

public enum ContraptionExactBlockProvider implements IEntityComponentProvider
{
    INSTANCE;

    static final ResourceLocation OBJECT_NAME_TAG;
    private long time = Long.MIN_VALUE;
    private BlockState hitBlock;
    private BlockHitResult hitResult;

    @Nullable
    public IElement getIcon(EntityAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (config.get(CreatePlugin.CONTRAPTION_EXACT_BLOCK) && this.validate()) {
            ItemStack stack = this.hitBlock.getCloneItemStack((HitResult)this.hitResult, (BlockGetter)accessor.getLevel(), this.hitResult.m_82425_(), accessor.getPlayer());
            return CreatePlugin.client.getElementHelper().item(stack);
        }
        return null;
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        ItemStack pick;
        if (!config.get(CreatePlugin.CONTRAPTION_EXACT_BLOCK) || !this.validate()) {
            return;
        }
        Object name = null;
        if (WailaClientRegistration.INSTANCE.shouldPick(this.hitBlock) && (pick = this.hitBlock.getCloneItemStack((HitResult)this.hitResult, (BlockGetter)accessor.getLevel(), this.hitResult.m_82425_(), accessor.getPlayer())) != null && !pick.m_41619_()) {
            name = pick.m_41786_();
        }
        if (name == null) {
            ItemStack pick2;
            String key = this.hitBlock.m_60734_().m_7705_();
            name = I18n.m_118936_((String)key) ? this.hitBlock.m_60734_().m_49954_() : ((pick2 = accessor.getPickedResult()) != null && !pick2.m_41619_() ? pick2.m_41786_() : new TextComponent(key));
        }
        tooltip.remove(OBJECT_NAME_TAG);
        tooltip.add(0, (Component)new TextComponent(String.format(config.getWailaConfig().getFormatting().getBlockName(), name.getString())).m_130948_(((WailaConfig)Waila.CONFIG.get()).getOverlay().getColor().getTitle().m_131155_(Boolean.valueOf(true))), OBJECT_NAME_TAG);
    }

    public void setHit(BlockHitResult hitResult, BlockState hitBlock) {
        this.hitResult = hitResult;
        this.hitBlock = hitBlock;
        this.time = Util.m_137550_();
    }

    private boolean validate() {
        return Util.m_137550_() - this.time < 10L;
    }

    static {
        OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    }
}

